<?php
// site/plugins/ausgezeichnet-seal/index.php

Kirby::plugin('myplugin/ausgezeichnet-seal', [
    'hooks' => [
        'page.render:after' => function ($html, $page) {
            $sealHtml = '
                <!-- Ausgezeichnet.org-Dynamic-Seal: Begin -->
                <div class="auorgDynamicSeal" 
                     auorg-data-type="rounded" 
                     auorg-data-position="right" 
                     auorg-data-margin-bottom="0" 
                     auorg-data-margin-horizontal="0" 
                     auorg-data-background-color="#ffffff" 
                     auorg-data-panel-background-color="#4e4d4d" 
                     auorg-data-panel-text-color="#ffffff">
                </div>
                <script src="https://siegel.ausgezeichnet.org/widget/js/wi"></script>
                <!-- Ausgezeichnet.org-Dynamic-Seal: End -->
            ';

            // Fügt das Siegel vor dem schließenden </body>-Tag ein
            return str_replace('</body>', $sealHtml . '</body>', $html);
        }
    ]
]);
