<?php
/**
 * AuorgDynamicSeal Module
 *
 * @package modules
 * @subpackage system
 * @copyright Copyright Webconia GmbH
 * @version $Id: auorg_dynamic_seal.php 2025-04-15 10:00:00Z webchills $
 */

defined('_VALID_XTC') or die('Direct Access to this location is not allowed.');

class auorg_dynamic_seal
{
    const INSTALLATION_TRACKING_URL = 'https://www.ausgezeichnet.org/api/webhook/plugin/installation?int_id={INTEGRATION_ID}&domain={WEBSHOP_URL}';

    const INTEGRATION_ID = '34051';

    var $code, $title, $description, $enabled, $_check;

    function __construct()
    {
        $this->code = 'auorg_dynamic_seal';
        $this->title = MODULE_SYSTEM_AUORG_DYNAMIC_SEAL_TEXT_TITLE;
        $this->description = MODULE_SYSTEM_AUORG_DYNAMIC_SEAL_TEXT_DESCRIPTION;
        $this->enabled = (defined('MODULE_SYSTEM_AUORG_DYNAMIC_SEAL_STATUS') && MODULE_SYSTEM_AUORG_DYNAMIC_SEAL_STATUS == 'true') ? true : false;
    }

    function install()
    {
        xtc_db_query("INSERT INTO " . TABLE_CONFIGURATION . "
            (configuration_key, configuration_value, configuration_group_id, sort_order, set_function, date_added)
            VALUES ('MODULE_SYSTEM_AUORG_DYNAMIC_SEAL_STATUS', 'true', '1', '1', 'xtc_cfg_select_option(array(\\'true\\', \\'false\\'), ', now())");

        xtc_db_query("INSERT INTO " . TABLE_CONFIGURATION . "
            (configuration_key, configuration_value, configuration_group_id, sort_order, date_added)
            VALUES ('MODULE_SYSTEM_AUORG_DYNAMIC_SEAL_ORG_ID', '', '1', '2', now())");

        xtc_db_query("INSERT INTO " . TABLE_CONFIGURATION . "
            (configuration_key, configuration_value, configuration_group_id, sort_order, set_function, date_added)
            VALUES ('MODULE_SYSTEM_AUORG_DYNAMIC_SEAL_SHOW_SEAL', 'true', '1', '3', 'xtc_cfg_select_option(array(\\'true\\', \\'false\\'), ', now())");

        xtc_db_query("INSERT INTO " . TABLE_CONFIGURATION . "
            (configuration_key, configuration_value, configuration_group_id, sort_order, set_function, date_added)
            VALUES ('MODULE_SYSTEM_AUORG_DYNAMIC_SEAL_SHOW_COLLECTOR', 'true', '1', '4', 'xtc_cfg_select_option(array(\\'true\\', \\'false\\'), ', now())");

        xtc_db_query("INSERT INTO " . TABLE_CONFIGURATION . "
            (configuration_key, configuration_value, configuration_group_id, sort_order, set_function, date_added)
            VALUES ('MODULE_SYSTEM_AUORG_DYNAMIC_SEAL_SEAL_DESIGN', 'rounded', '1', '5', 'xtc_cfg_select_option(array(\\'rounded\\', \\'square\\'), ', now())");

        xtc_db_query("INSERT INTO " . TABLE_CONFIGURATION . "
            (configuration_key, configuration_value, configuration_group_id, sort_order, date_added)
            VALUES ('MODULE_SYSTEM_AUORG_DYNAMIC_SEAL_DOMAIN', '', '1', '6', now())");

        xtc_db_query("INSERT INTO " . TABLE_CONFIGURATION . "
            (configuration_key, configuration_value, configuration_group_id, sort_order, date_added)
            VALUES ('MODULE_SYSTEM_AUORG_DYNAMIC_SEAL_DOMAIN_TRACKED', '', '1', '7', now())");

        $file = DIR_FS_CATALOG . 'includes/application_bottom.php';
        $code = "include_once(DIR_FS_CATALOG . 'includes/modules/auorg_dynamic_seal_output.php');";
        $content = file_get_contents($file);

        if (strpos($content, $code) === false) {
            if (strpos($content, '?>') !== false) {
                $content = str_replace('?>', "\n// AUSGEZEICHNET.org Plugin\n$code;\n?>", $content);
            } else {
                $content .= "\n// AUSGEZEICHNET.org Plugin\n$code;\n";
            }
            file_put_contents($file, $content);
        }
    }

    function remove()
    {
        xtc_db_query("DELETE FROM " . TABLE_CONFIGURATION . " WHERE configuration_key IN ('" . implode("', '", $this->keys()) . "')");

        $file = DIR_FS_CATALOG . 'includes/application_bottom.php';
        $code = "include_once(DIR_FS_CATALOG . 'includes/modules/auorg_dynamic_seal_output.php');";
        $content = file_get_contents($file);
        $content = str_replace("// AUSGEZEICHNET.org Plugin\n$code;\n", '', $content);
        file_put_contents($file, $content);
    }

    function keys()
    {
        return array(
            'MODULE_SYSTEM_AUORG_DYNAMIC_SEAL_STATUS',
            'MODULE_SYSTEM_AUORG_DYNAMIC_SEAL_ORG_ID',
            'MODULE_SYSTEM_AUORG_DYNAMIC_SEAL_SHOW_SEAL',
            'MODULE_SYSTEM_AUORG_DYNAMIC_SEAL_SHOW_COLLECTOR',
            'MODULE_SYSTEM_AUORG_DYNAMIC_SEAL_SEAL_DESIGN',
            'MODULE_SYSTEM_AUORG_DYNAMIC_SEAL_DOMAIN',
        );
    }

    function process($file)
    {
        return false;
    }

    function display()
    {
        $tracking_query = xtc_db_query(
            "SELECT configuration_value FROM "
                . TABLE_CONFIGURATION
                . " WHERE configuration_key = 'MODULE_SYSTEM_AUORG_DYNAMIC_SEAL_DOMAIN_TRACK'",
        );
        if (!xtc_db_num_rows($tracking_query)) {
            $domain_query = xtc_db_query(
                "SELECT configuration_value FROM "
                . TABLE_CONFIGURATION
                . " WHERE configuration_key = 'MODULE_SYSTEM_AUORG_DYNAMIC_SEAL_DOMAIN'",
            );
            $row = xtc_db_fetch_array($domain_query);
            $domain = $row['configuration_value'];
            if ($domain) {
                xtc_db_query(
                    'INSERT INTO '
                    . TABLE_CONFIGURATION
                    . '(configuration_key, configuration_value, configuration_group_id, sort_order, date_added)'
                    . " VALUES('MODULE_SYSTEM_AUORG_DYNAMIC_SEAL_DOMAIN_TRACK', 1, 1, 7, now())",
                );
                $url = str_replace(
                    ['{INTEGRATION_ID}', '{WEBSHOP_URL}'],
                    [self::INTEGRATION_ID, $domain],
                    self::INSTALLATION_TRACKING_URL,
                );
                file_get_contents($url);
            }
        }

        return array('text' =>
            '<br><b>' . MODULE_SYSTEM_AUORG_DYNAMIC_SEAL_HELP_LINKS_TITLE . '</b><br>' .
            '<a href="https://www.ausgezeichnet.org/hilfe-center/" target="_blank">' . MODULE_SYSTEM_AUORG_DYNAMIC_SEAL_HELP_LINK_HELP . '</a><br>' .
            '<a href="https://www.ausgezeichnet.org/de_DE/registrierung/plugin-test-account" target="_blank">' . MODULE_SYSTEM_AUORG_DYNAMIC_SEAL_HELP_LINK_REGISTER . '</a><br><br>' .
            xtc_button(BUTTON_REVIEW_APPROVE) . '&nbsp;' .
            xtc_button_link(BUTTON_CANCEL, xtc_href_link(FILENAME_MODULE_EXPORT, 'set=' . $_GET['set'] . '&module=' . $this->code))
        );
    }

    function check()
    {
        if (!isset($this->_check)) {
            $check_query = xtc_db_query("SELECT configuration_value FROM " . TABLE_CONFIGURATION . " WHERE configuration_key = 'MODULE_SYSTEM_AUORG_DYNAMIC_SEAL_STATUS'");
            $this->_check = xtc_db_num_rows($check_query);
        }
        return $this->_check;
    }
}

?>
