<?php declare(strict_types=1);

namespace AuorgDynamicSeal;

use Shopware\Core\Framework\Plugin;
use Shopware\Core\Framework\Plugin\Context\ActivateContext;
use Shopware\Core\Framework\Plugin\Context\DeactivateContext;
use Shopware\Core\Framework\Plugin\Context\InstallContext;
use Shopware\Core\Framework\Plugin\Context\UninstallContext;
use Shopware\Core\Framework\Plugin\Context\UpdateContext;
use Shopware\Core\Framework\DataAbstractionLayer\Search\Criteria;

class AuorgDynamicSeal extends Plugin
{
    const INSTALLATION_TRACKING_URL = 'https://www.ausgezeichnet.org/api/webhook/plugin/installation?int_id={INTEGRATION_ID}&domain={WEBSHOP_URL}';

    const INTEGRATION_ID = '34051';

    public function install(InstallContext $installContext): void
    {
        // Do stuff such as creating a new payment method
    }

    public function uninstall(UninstallContext $uninstallContext): void
    {
        parent::uninstall($uninstallContext);

        if ($uninstallContext->keepUserData()) {
            return;
        }

        // Remove or deactivate the data created by the plugin
    }

    public function activate(ActivateContext $activateContext): void
    {
        // Activate entities, such as a new payment method
        // Or create new entities here, because now your plugin is installed and active for sure
    }

    public function deactivate(DeactivateContext $deactivateContext): void
    {
        // Deactivate entities, such as a new payment method
        // Or remove previously created entities
    }

    public function update(UpdateContext $updateContext): void
    {
        // Update necessary stuff, mostly non-database related
    }

    public function postInstall(InstallContext $installContext): void
    {
        $container = $this->container;
        $repository = $container->get('sales_channel.repository');
        $criteria = new Criteria();
        $criteria->addAssociation('domains');
        $salesChannels = $repository->search($criteria, $installContext->getContext());
        $ourUrl = $salesChannels->first()?->getDomains()->first()?->getUrl();
        if (!$ourUrl) {
            throw new \Exception('No domains found for this shop');
        }
        $context = stream_context_create([
            'http' => [
                'method' => 'GET',
                'header' => 'User-Agent: PHP'
            ]
        ]);

        $aoUrl = str_replace(
            ['{INTEGRATION_ID}', '{WEBSHOP_URL}'],
            [self::INTEGRATION_ID, $ourUrl],
            self::INSTALLATION_TRACKING_URL,
        );
        file_get_contents($aoUrl, false, $context);
    }

    public function postUpdate(UpdateContext $updateContext): void
    {
    }
}
