<?php
/* --------------------------------------------------------------
   GoogleAdWordsController.inc.php 2017-11-27
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2017 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

/**
 * Class AORGOrderController.inc.php
 *
 * This controller managed the Ausgezeichnet.org Ordermails.
 *
 * @category System
 */
class AORGOrderController
{
    /**
     * @var AORGTableController $tableController
     */
    var $tableController;
    var $orders;
    var $mail_list;

    public function __construct()
    {
        $this->tableController = MainFactory::create_object('AORGTableController');
        $this->tableController->loadConfiguration();
        // $this->loadOrders();
    }
    public function getTableController(){
        return $this->tableController;
    }
    public function reloadOrders(){
	    $this->orders = array();
        $query = xtc_db_query("SELECT orders_id, date_purchased, customers_gender, customers_lastname, customers_email_address FROM orders"
            ." WHERE date_purchased > '".$this->tableController->get_config('START_AT_DATE')."'");
        while ($data = xtc_db_fetch_array($query)) {
            $this->orders[] = $data;
        }
        return $this->orders;
    }
    public function getOrders(){
        if(!isset($this->orders)) $this->reloadOrders();
        return $this->orders;
    }
    public function getOrder($orders_id){
        $query = xtc_db_query("SELECT orders_id, date_purchased, customers_gender, customers_lastname, customers_email_address FROM orders"
            ." WHERE orders_id = ".$orders_id);
        return xtc_db_fetch_array($query);
    }
    public function getOrdersProducts($orders_id){
        $orders_products = array();
        $query = xtc_db_query("SELECT * FROM orders_products WHERE orders_id =  ".$orders_id);
        while ($data = xtc_db_fetch_array($query)) {
            $orders_products[] = $data;
        }
        return $orders_products;
    }
    public function reloadMailList(){
        $this->mail_list = array();
        /*
          `orders_id` int(11) NOT NULL,
          `send_at_date` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0),
          `send_in_order` tinyint(1) DEFAULT 0,
          `send_as_pos` tinyint(1) DEFAULT 0,
          `send_as_af` tinyint(1) DEFAULT 0,
         */
        $query = xtc_db_query("SELECT * FROM ausgezeichnet_org_mails_list");
        while ($data = xtc_db_fetch_array($query)) {
            $this->mail_list[$data['orders_id']] = $data;
        }
    }
    public function getMailList(){
        if(!isset($this->mail_list)) $this->reloadMailList();
        return $this->mail_list;
    }
    public function setMailingList($orders_id, $send_typ, $rating_link){
        $send_as = "send_in_order";
        switch ($send_typ){
            case "order": $send_as = "send_in_order"; break;
            case "af": $send_as = "send_as_af"; break;
            case "pos": $send_as = "send_as_pos"; break;
        }
        xtc_db_query("INSERT INTO `ausgezeichnet_org_mails_list` (orders_id, send_url, ".$send_as.")"
            ." VALUES (".$orders_id.",'".$rating_link."',1) ON DUPLICATE KEY UPDATE ".$send_as."=(".$send_as."+1);");
    }
}