<?php
/* --------------------------------------------------------------
   GoogleAdWordsController.inc.php 2017-11-27
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2017 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

/**
 * Class AORGTableController.inc.php
 *
 * This controller created and managed the Ausgezeichnet.org Tables.
 *
 * @category System
 * @package  AdminHttpViewControllers
 */
class AORGTableController
{
    var $configuration;
    var $orders_mails;

    public function __construct()
    {
        $this->check();
    }

    public function check()
	{
        if(!xtc_db_num_rows(xtc_db_query("SHOW TABLES LIKE 'ausgezeichnet_org_configuration'"))){
            xtc_db_query("CREATE TABLE `ausgezeichnet_org_configuration`  ("
                ."`configuration_key` varchar(120) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,"
                ."`configuration_value` text CHARACTER SET utf8 COLLATE utf8_general_ci,"
                ."PRIMARY KEY (`configuration_key`) USING BTREE) ENGINE = MyISAM CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;");

            $this->set_config('START_AT_DATE',date("Y-m-d")." 00:00:00");
            $this->set_config('AORG_LINK','');
            $this->set_config('AORG_CUSTOMER_NUMBER','');
            $this->set_config('AORG_CUSTOMER_SALT','');
            $this->set_config('AORG_SEND_WITH_ORDER','1'); // Sende direkt nach bestellung
            $this->set_config('AORG_SEND_IN_ORDERMAIL','1'); // Link in Bestellung integrieren
            $this->set_config('AORG_SEND_MAIL_AFTER_X_DAYS','7'); // Sende erst nach x Tagen
            $this->set_config('AORG_AUTO_SEND_START_AFTER_ORDER',''); // Obrige ausführung nach jeder Bestellung prüfen und senden
            $this->set_config('AORG_MAIL_ABSENDER','');
            $this->set_config('AORG_REVIEW_COLLECTOR', '');
            $this->set_config('AORG_SIEGEL', '');
            $this->set_config('AORG_REVIEW_COLLECTOR_ACTIV', '1');
            $this->set_config('AORG_SIEGEL_ACTIV', '1');

        }
        if(!xtc_db_num_rows(xtc_db_query("SHOW TABLES LIKE 'ausgezeichnet_org_mails_list'"))){
            xtc_db_query("CREATE TABLE `ausgezeichnet_org_mails_list`  (
              `orders_id` int(11) NOT NULL,
              `send_url` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
              `send_at_date` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0),
              `send_in_order` tinyint(1) DEFAULT 0,
              `send_as_pos` tinyint(1) DEFAULT 0,
              `send_as_af` tinyint(1) DEFAULT 0,
              PRIMARY KEY (`orders_id`) USING BTREE
            ) ENGINE = MyISAM CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;");
        }
    }
    public function loadConfiguration(){
	    $this->configuration = array();
        $config_query = xtc_db_query("SELECT * FROM ausgezeichnet_org_configuration");
        while ($config = xtc_db_fetch_array($config_query)) {
            $this->configuration[$config['configuration_key']] = $config;
        }
    }
    public function set_config($configuration_key, $value){
        xtc_db_query("INSERT INTO `ausgezeichnet_org_configuration` (configuration_key, configuration_value)"
            ." VALUES ('".$configuration_key."','".$value."') ON DUPLICATE KEY UPDATE configuration_value=VALUES(configuration_value);");
    }
    public function get_config($configuration_key){
        return $this->configuration[$configuration_key]['configuration_value'];
    }
    public function getRatingInvitationUrl($orders_id, $collectionMethod = "pos"){
        $baseUrl = trim($this->get_config('AORG_LINK'));
        $transactionId = $orders_id;
        $customers_number = trim($this->get_config('AORG_CUSTOMER_NUMBER'));
        $salt = trim($this->get_config('AORG_CUSTOMER_SALT'));
        $hash = md5($customers_number."/" . $transactionId . "/" . $collectionMethod . "/".$salt);
        return $baseUrl.'?txid='.$transactionId.'&collmethod='.$collectionMethod.'&hash='.$hash;
    }
    public function getRatingInvitationUrlPur($orders_id, $collectionMethod = "pos"){
        $baseUrl = trim($this->get_config('AORG_LINK'));
        $transactionId = $orders_id;
        $customers_number = trim($this->get_config('AORG_CUSTOMER_NUMBER'));
        $salt = trim($this->get_config('AORG_CUSTOMER_SALT'));
        $hash = $customers_number."/" . $transactionId . "/" . $collectionMethod . "/".$salt;
        return $baseUrl.'?txid='.$transactionId.'&collmethod='.$collectionMethod.'&hash='.$hash;
    }
}