<?php
/* --------------------------------------------------------------
   SampleApplicationBottomExtender.inc.php 2016-03-07
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2016 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

/**
 * Class AORGApplicationBottomExtender
 *
 * This is a overload for the ApplicationBottomExtenderComponent.
 *
 * @see ApplicationBottomExtenderComponent
 */
class AORGApplicationBottomExtender extends AORGApplicationBottomExtender_parent
{
    /**
     * Overloaded "proceed" method.
     */
    /**
     * @var AORGTableController $tableController
     */
    var $tableController;

    public function proceed()
    {
        $this->tableController = MainFactory::create_object('AORGTableController');
        $this->tableController->loadConfiguration();
        $this->_setSiegel();

        parent::proceed();
    }
    protected function _setSiegel(){
        if($this->tableController->get_config('AORG_SIEGEL_ACTIV') == "1"){
            $this->v_output_buffer[] = $this->tableController->get_config('AORG_SIEGEL');
        }
    }
}