<?php
/* --------------------------------------------------------------
   SampleCheckoutSuccessExtender.inc.php 2016-03-07
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2016 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

/**
 * Class AORGCheckoutSuccessExtender
 *
 * This is a overload for the CheckoutSuccessExtenderComponent.
 *
 * @see CheckoutSuccessExtenderComponent
 */
class AORGCheckoutSuccessExtender extends AORGCheckoutSuccessExtender_parent
{
    /**
     * Overloaded "proceed" method.
     */
    /**
     * @var AORGOrderController $orderController
     */
    var $orderController;
    /**
     * @var AORGTableController $tableController
     */
    var $tableController;
    /**
     * @var AORGMailer $mailer
     */
    var $mailer;
    var $orderId;

    public function proceed()
    {
        parent::proceed();

        $this->orderId = new IdType($this->v_data_array['orders_id']);

        $this->orderController = MainFactory::create_object('AORGOrderController');
        $this->tableController = $this->orderController->getTableController();
        $this->mailer = MainFactory::create_object('AORGMailer');

        /*echo "<pre>";
        print_r($this);
        echo "</pre>";*/
        $this->_a_org_process($this->orderId, $_SESSION['language_code']);

        $this->html_output_array[] = $this->_setReviewCollector();
    }
    
    protected function _a_org_process($order_id, $language_code){

        if($this->tableController->get_config('AORG_SEND_WITH_ORDER') == 1){
            $order = $this->orderController->getOrder($order_id);
            $a_org_rating_link = $this->tableController->getRatingInvitationUrl($order_id,"pos");
            $mail_html = $this->mailer->createMail($order,$this->orderController->getOrdersProducts($order_id), $a_org_rating_link, $language_code);
            $this->mailer->sendMessage($this->tableController->get_config('AORG_MAIL_ABSENDER'),$order['customers_email_address'],"",$this->tableController->get_config('AORG_MAIL_BETREFF'),$mail_html);

            //$a_org_rating_link_pur = $this->tableController->getRatingInvitationUrlPur($order_id,"af");
            //$mail_html2 = $this->mailer->createMail($order,$this->orderController->getOrdersProducts($order_id), $a_org_rating_link_pur, $language_code);
            //$this->mailer->sendMessage($this->tableController->get_config('AORG_MAIL_ABSENDER'),$order['customers_email_address'],"",$this->tableController->get_config('AORG_MAIL_BETREFF'),$mail_html2);

            $this->orderController->setMailingList($order_id,'order',$a_org_rating_link);

        }
        if($this->tableController->get_config('AORG_AUTO_SEND_START_AFTER_ORDER') == 1){

            $date_now = new DateTime();
            $orders = $this->orderController->getOrders();
            $this->orderController->reloadMailList();
            $mails  = $this->orderController->getMailList();

            for($i=0;$i<sizeof($orders);$i++){
                $is_sended = array_key_exists($orders[$i]['orders_id'],$mails);
                if($is_sended) $is_sended = $mails[$orders[$i]['orders_id']]['send_as_af'];

                if(!$is_sended){ // Bestellung mit send_as_af wurde nicht gesendet
                    $date_purchased = new DateTime($orders[$i]['date_purchased']);
                    $date_purchased = $date_purchased->modify('+'.$this->tableController->get_config('AORG_SEND_MAIL_AFTER_X_DAYS').' days');
                    if($date_now->getTimestamp() > $date_purchased->getTimestamp()){ // HEUTE > (Kaufdatum + AORG_SEND_MAIL_AFTER_X_DAYS)
                        $rating_link = $this->tableController->getRatingInvitationUrl($orders[$i]['orders_id'],"af");
                        $mail_html = $this->mailer->createMail($orders[$i],$this->orderController->getOrdersProducts($orders[$i]['orders_id']),$rating_link, $language_code);
                        $this->mailer->sendMessage($this->tableController->get_config('AORG_MAIL_ABSENDER'),$orders[$i]['customers_email_address'],"",$this->tableController->get_config('AORG_MAIL_BETREFF'),$mail_html);
                        $this->orderController->setMailingList($orders[$i]['orders_id'],'af',$rating_link);
                    }
                }
            }
        }
    }
    protected function _setReviewCollector()
    {

        if($this->tableController->get_config('AORG_REVIEW_COLLECTOR_ACTIV') == "1"){
            $this->html_output_array[] = $this->tableController->get_config('AORG_REVIEW_COLLECTOR');
        }
    }

}