<?php
/**
 * @var AORGOrderController $orderController
 */

class AORGSendOrderContentView extends AORGSendOrderContentView_parent
{
	public function get_mail_content_array()
	{
        $this->set_content_data('AORGRatingInvitationUrl', $this->_a_org_process($this->order_id));
	    return parent::get_mail_content_array();
    }
    protected function _a_org_process($order_id){
        /**
        * @var AORGOrderController $orderController
        */
        $orderController = MainFactory::create_object('AORGOrderController');
        /**
         * @var AORGTableController $tableController
         */
        $tableController = $orderController->getTableController();
        $tableController->loadConfiguration();

        if($tableController->get_config('AORG_SEND_IN_ORDERMAIL') == 1){
            $rating_link =  $tableController->getRatingInvitationUrl($order_id,"pos");
            $orderController->setMailingList($order_id,'pos',$rating_link);
            return $rating_link;
        }else{
            return "";
        }

    }
}
