<?php

class AusgezeichnetOrgCron extends oxUBase
{

    public function render()
    {
        //Increase execution time for the script to run without timeouts
        set_time_limit(3600);

        // get config
        $config      = oxRegistry::get('oxConfig');

        // get secret key
        $oxConfig = oxNew('oxconfig');
        $secret_test = $oxConfig->getRequestParameter('secret');

        if ($config->getConfigParam('AusgezeichnetOrgMailCronSecret') == $secret_test &&
            $config->getConfigParam('AusgezeichnetOrgMailTime') == 1 &&
            is_numeric($config->getConfigParam('AusgezeichnetOrgMailTimeDay')) &&
            $config->getConfigParam('AusgezeichnetOrgMailTimeDay') > 0) {

            // get orders
            $oDb = oxDb::getDb();
            $sSelect = "select oxid from oxorder where datediff(now(), `oxorderdate`) = " . $oDb->quote($config->getConfigParam('AusgezeichnetOrgMailTimeDay')) . " and `ausgezeichnet_org_status` = 0 and `oxstorno` = 0 and oxsenddate > 0";
            $oxOrder_array = $oDb->getAll($sSelect);

            if (is_array($oxOrder_array) && sizeof($oxOrder_array) > 0) {
                $count = 0;
                foreach ($oxOrder_array as $order) {
                    $oxOrder = oxNew('oxorder');
                    $oxOrder->load($order[0]);

                    // check order
                    if ($oxOrder->getId()) {
                        // send mail
                        $oxEmail = oxNew('oxemail');
                        if ($oxEmail->sendAusgezeichnetOrgEmailToUser($oxOrder, $oxEmail::COLLECTION_METHOD_AFTER_FULLFILLMENT)) {
                            $oxOrder->setAusgezeichnetOrgStatus();
                            $count++;
                        }
                    }
                }
                if ($count > 0) {
                    echo "AusgezeichnetOrg - " . $count . " rating mails send";
                }
                else {
                    echo "AusgezeichnetOrg - no rating mails send";
                }
            }
            else {
                echo "AusgezeichnetOrg - no rating mails to send";
            }
        }
        else {
            echo "AusgezeichnetOrg - check your plugin settings";
        }
    }
}