<?php

class AusgezeichnetOrgEmail extends AusgezeichnetOrgEmail_parent
{
    /**
     * @var string
     */
    protected $_sAusgezeichnetOrgTemplate = "ausgezeichnetorg_email.tpl";

    const COLLECTION_METHOD_POINT_OF_SALE = 'pos';
    const COLLECTION_METHOD_AFTER_FULLFILLMENT = 'af';

    /**
     * @param $order
     * @param null $subject
     * @return mixed
     */
    public function sendAusgezeichnetOrgEmailToUser($order, $method = self::COLLECTION_METHOD_POINT_OF_SALE)
    {
        // add user defined stuff if there is any
        $order  = $this->_addUserInfoOrderEMail($order);
        $language = oxRegistry::getLang();
        $blAdmin = $language->isAdmin();

        $iLang = $language->getTplLanguage();
        $sTranslation = $language->translateString( 'AUSGEZEICHNET_ORG_MAIL_SUBJECT', $iLang, $blAdmin );

        $shop = $this->_getShop();
        $this->_setMailParams($shop);

        $user = $order->getOrderUser();
        $this->setUser($user);

        $vars = array(
            'ausgezeichnet_org'  => array(
                'ordernumber' => $order->oxorder__oxordernr->value,
                'orderdate' => date('d.m.Y', strtotime($order->oxorder__oxorderdate->value)),
                'ratinglink' => $this->buildRatingLink($order, $method)
            )
        );

        // create messages
        $smarty = $this->_getSmarty();
        $this->setViewData("ausgezeichnet_org", $vars['ausgezeichnet_org']);

        // Process view data array through oxOutput processor
        $this->_processViewArray();
        $this->setBody($smarty->fetch($this->_sAusgezeichnetOrgTemplate));

        $subject =  $shop->oxshops__oxname->value . ', ' . $sTranslation;

        $this->setSubject($subject);

        $fullName = $user->oxuser__oxfname->getRawValue() . " " . $user->oxuser__oxlname->getRawValue();

        $this->setRecipient($user->oxuser__oxusername->value, $fullName);
        $this->setReplyTo($shop->oxshops__oxorderemail->value, $shop->oxshops__oxname->getRawValue());

        return $this->send();
    }

    /**
     * @param $order
     * @param $method
     * @return bool|string|void
     */
    private function buildRatingLink($order, $method)
    {
        if (!$order || !is_string($method)) return;

        $config = oxRegistry::get('oxConfig');

        if (is_string($config->getConfigParam('AusgezeichnetOrgCustomerNumber')) &&
            strlen($config->getConfigParam('AusgezeichnetOrgCustomerNumber')) > 0 &&
            is_string($config->getConfigParam('AusgezeichnetOrgIndividualRatingID')) &&
            strlen($config->getConfigParam('AusgezeichnetOrgIndividualRatingID')) > 0 &&
            is_string($config->getConfigParam('AusgezeichnetOrgProfilLink')) &&
            strlen($config->getConfigParam('AusgezeichnetOrgProfilLink')) > 0) {

            $hash = md5($config->getConfigParam('AusgezeichnetOrgCustomerNumber') . '/' . $order->oxorder__oxordernr->value . '/' . $method . '/' . $config->getConfigParam('AusgezeichnetOrgIndividualRatingID'));
            $ratinglink = $config->getConfigParam('AusgezeichnetOrgProfilLink') . '?txid=' . $order->oxorder__oxordernr->value . '&collmethod=' . $method . '&hash=' . $hash ;

            return $ratinglink;
        }
        else {
            return false;
        }
    }
}