<?php

class AusgezeichnetOrgEvents
{

    /**
     * @throws \OxidEsales\Eshop\Core\Exception\DatabaseConnectionException
     * @throws \OxidEsales\Eshop\Core\Exception\DatabaseErrorException
     */
    public static function onActivate()
    {
        $oDb = oxDb::getDb();

        $blAttPresent = (bool) $oDb->getOne('SHOW COLUMNS FROM oxorder LIKE "ausgezeichnet_org_status"');

        if (!$blAttPresent) {
            $sSql = 'ALTER TABLE oxorder ADD ausgezeichnet_org_status INT (1) NOT NULL DEFAULT 0';
            $oDb->execute( $sSql );
        }

        $blAttPresent = (bool) $oDb->getOne('SELECT * FROM oxcontents WHERE OXID = "ausgezeichnetorgEmail"');

        if (!$blAttPresent) {

            $oxcontent = oxNew('oxcontent');
            $oxcontent->setId('ausgezeichnetorgEmail');
            $oxcontent->oxcontents__oxloadid->value = 'ausgezeichnetorgEmail';
            $oxcontent->setShopId(1);
            $oxcontent->setType(0);
            $oxcontent->oxcontents__oxactive->value = 1;
            $oxcontent->oxcontents__oxactive_1->value = 1;
            $oxcontent->setTitle('ausgezeichnet.org E-Mail');
            $oxcontent->oxcontents__oxcontent->value =  "<p class='mid'>".
                                                        "Bewerten Sie Ihre Bestellung mit der Bestellnummer: [{\$ausgezeichnet_org.ordernumber}] vom [{\$ausgezeichnet_org.orderdate}]".
                                                        "</p>".
                                                        "<p class='mid'>".
                                                        "<br>".
                                                        "Sehr geehrter Kunde,<br>".
                                                        "<br>".
                                                        "waren Sie mit unserem Service zufrieden ? <br>".
                                                        "<br>".
                                                        "Teilen Sie Ihre Meinung und bewerten Sie uns, um auch anderen Kunden ein noch besseres Kauferlebnis zu ermöglichen.<br>".
                                                        "<br>".
                                                        "Vielen Dank !<br>".
                                                        "<br><br>".
                                                        "<a class=\"rating\" href=\"[{\$ausgezeichnet_org.ratinglink}]\">hier</a>".
                                                        "</p>";

            $oxcontent->oxcontents__oxfolder->value = 'CMSFOLDER_EMAILS';
            $oxcontent->setCategoryId('30e44ab83fdee7564.23264141');
            $oxcontent->save();
        }

    }

    /**
     * @throws \OxidEsales\Eshop\Core\Exception\DatabaseConnectionException
     * @throws \OxidEsales\Eshop\Core\Exception\DatabaseErrorException
     */
    public static function onDeactivate()
    {
        $oDb = oxDb::getDb();

        $blAttPresent = (bool) $oDb->getOne('SHOW COLUMNS FROM oxorder LIKE "LEOPARDEN_OXSERIESRUNNINGTIME"');

        if ($blAttPresent) {
            $sSql = 'ALTER TABLE oxorder DROP ausgezeichnet_org_status';
            $oDb->execute( $sSql );
        }

        $blAttPresent = (bool) $oDb->getOne('SELECT * FROM oxcontents WHERE OXID = "ausgezeichnetorgEmail"');

        if ($blAttPresent) {
            $sSql = 'DELETE FROM oxcontents WHERE OXID = "ausgezeichnetorgEmail"';
            $oDb->execute( $sSql );
        }
    }
}