<?php

class AusgezeichnetOrgOrder extends AusgezeichnetOrgOrder_parent
{
    /**
     * @param \OxidEsales\Eshop\Application\Model\Basket $oBasket
     * @param $oUser
     * @param bool $blRecalculatingOrder
     * @return mixed
     * @throws \OxidEsales\Eshop\Core\Exception\DatabaseConnectionException
     * @throws \OxidEsales\Eshop\Core\Exception\DatabaseErrorException
     */
    public function finalizeOrder(oxBasket $oBasket, $oUser, $blRecalculatingOrder = false)
    {
        $iRet = parent::finalizeOrder($oBasket, $oUser, $blRecalculatingOrder);

        // get config
        $config      = oxRegistry::get('oxConfig');

        if ($iRet == 1 && $config->getConfigParam('AusgezeichnetOrgMailTime') == 2) {
            $oxEmail = oxNew('oxemail');
            // send ausgezeichnetorg email to user
            if ($oxEmail->sendAusgezeichnetOrgEmailToUser($this)) {
                // mail to user was successfully sent
                $iRet = self::ORDER_STATE_OK;

                // set ausgezeichnetorgstatus
                $this->setAusgezeichnetOrgStatus();
            }
        }

        return $iRet;
    }

    /**
     * @throws \OxidEsales\Eshop\Core\Exception\DatabaseConnectionException
     * @throws \OxidEsales\Eshop\Core\Exception\DatabaseErrorException
     */
    public function setAusgezeichnetOrgStatus() {
        $oDb = oxDb::getDb();

        if ($this->getId()) {
            $sQ = 'update oxorder set ausgezeichnet_org_status=' . $oDb->quote(1) . ' where oxid=' . $oDb->quote($this->getId());
            $oDb->execute($sQ);

            //updating order object
            $field = oxNew('oxfield');
            $field->setValue(1);
            $this->oxorder__ausgezeichnet_org_status = $field;
        }
    }
}