<?php declare(strict_types=1);

namespace Plugin\tp_ausgezeichnet_script;

use JTL\Events\Dispatcher;
use JTL\Plugin\Bootstrapper;
use JTL\Shop;
use JTL\Smarty\JTLSmarty;
use stdClass;

/**
 * Class Bootstrap
 * @package Plugin\tp_ausgezeichnet_script
 */
class Bootstrap extends Bootstrapper
{
    /**
     * @inheritDoc
     */
    public function boot(Dispatcher $dispatcher): void
    {
        parent::boot($dispatcher);

		$plugin = $this->getPlugin();
		$db = $this->getDB();
		$cache = $this->getCache();

		$dispatcher->listen('shop.hook.' . \HOOK_SMARTY_OUTPUTFILTER, function ($args) use ($plugin) {

			require_once $plugin->getPaths()->getBasePath() . 'helper/selector.php';
			
		});
		
	}
    
}
