<?php

/**
 * Admin Page
 */


// Create WordPress admin menu
function ausgezeichnetSettings(){

    ausgezeichnetLocalize();

    add_submenu_page(
        'options-general.php',
        __('AUSGEZEICHNET.org Einstellungen', 'ausgezeichnet-org'),
        __('AUSGEZEICHNET.org', 'ausgezeichnet-org'),
        'manage_options',
        'ausgezeichnet-org',
        'ausgezeichnetPage'
    );

}
add_action('admin_menu','ausgezeichnetSettings');


// Register database fields
function ausgezeichnetFields() {        
    register_setting('ausgezeichnet-settings', 'ausgezeichnet_kontonummer');
    register_setting('ausgezeichnet-settings', 'ausgezeichnet_bewertungs_id');
    register_setting('ausgezeichnet-settings', 'ausgezeichnet_organisations_id');
    register_setting('ausgezeichnet-settings', 'ausgezeichnet_url_bewertungsseite');
    register_setting('ausgezeichnet-settings', 'ausgezeichnet_bewertungs_url');
    register_setting('ausgezeichnet-settings', 'ausgezeichnet_siegel_aktiv');
    register_setting('ausgezeichnet-settings', 'ausgezeichnet_siegel_typ');
    register_setting('ausgezeichnet-settings', 'ausgezeichnet_review_collector_aktiv');
    register_setting('ausgezeichnet-settings', 'ausgezeichnet_email_link1');
    register_setting('ausgezeichnet-settings', 'ausgezeichnet_email_link2');
    register_setting('ausgezeichnet-settings', 'ausgezeichnet_email_link3');
    register_setting('ausgezeichnet-settings', 'ausgezeichnet_email_link4');
}
add_action( 'admin_init', 'ausgezeichnetFields');


// Create WordPress plugin page
function ausgezeichnetPage(){ 

    ausgezeichnetLocalize();
            
    ?>

    <div class="wrap">
        <h1 class="wp-heading-inline"><?php echo __('Settings-Headline', 'ausgezeichnet-org'); ?></h1>
        <p><?php echo __('Settings-Description', 'ausgezeichnet-org'); ?></p>
        <ol>
            <li><?php echo __('Settings-Description Listenpunkt 1', 'ausgezeichnet-org'); ?></li>
            <li><?php echo __('Settings-Description Listenpunkt 2', 'ausgezeichnet-org'); ?></li>
            <li><?php echo __('Settings-Description Listenpunkt 3', 'ausgezeichnet-org'); ?></li>
        </ol>

        <form method="post" action="options.php">
            <?php settings_fields('ausgezeichnet-settings'); ?>
            <?php do_settings_sections('ausgezeichnet-settings'); ?>


            <div class="postbox">
                <div class="inside">
                    <h2><?php echo __('Kunden-Konto-Headline', 'ausgezeichnet-org'); ?></h2> 
                    <p><?php echo __('Kunden-Konto-Beschreibung', 'ausgezeichnet-org'); ?></p>
                </p>
                    
                    <table class="form-table">            

                        <tr valign="top">
                            <th scope="row"><?php echo __('Kontonummer', 'ausgezeichnet-org'); ?><span>*</span></th>
                            <td>
                                <input type="text" class="regular-text" name="ausgezeichnet_kontonummer" value="<?php echo esc_attr(get_option('ausgezeichnet_kontonummer')); ?>"/>
                                <!-- <p class="description"><?php echo __('Kontonummer-Beschreibung', 'ausgezeichnet-org'); ?></p> -->
                            </td>
                        </tr>

                        <tr valign="top">
                            <th scope="row"><?php echo __('Individuelle Bewertungs-ID', 'ausgezeichnet-org'); ?><span>*</span></th>
                            <td>
                                <input type="text" class="regular-text" name="ausgezeichnet_bewertungs_id" value="<?php echo esc_attr(get_option('ausgezeichnet_bewertungs_id')); ?>"/>
                                <!-- <p class="description"><?php echo __('Bewertungs-ID-Beschreibung', 'ausgezeichnet-org'); ?></p> -->
                            </td>
                        </tr>

                        <tr valign="top">
                            <th scope="row"><?php echo __('Organisations-ID', 'ausgezeichnet-org'); ?><span>*</span></th>
                            <td>
                                <input type="text" class="regular-text" name="ausgezeichnet_organisations_id" value="<?php echo esc_attr(get_option('ausgezeichnet_organisations_id')); ?>"/>
                                <!-- <p class="description"><?php echo __('Organisations-ID-Beschreibung', 'ausgezeichnet-org'); ?></p> -->
                            </td>
                        </tr>

                        <!-- <tr valign="top">
                            <th scope="row"><?php // echo __('URL der Bewertungsseite', 'ausgezeichnet-org'); ?></th>
                            <td>
                                <input type="text" class="regular-text" name="url_bewertungsseite" value="<?php // echo esc_attr(get_option('ausgezeichnet_url_bewertungsseite')); ?>"/>
                                <p class="description"><?php // echo __('Bewertungsseite Beschreibung', 'ausgezeichnet-org'); ?></p>
                            </td>
                        </tr> -->

                        <tr valign="top">
                            <th scope="row"><?php echo __('Bewertungs-URL', 'ausgezeichnet-org'); ?><span>*</span></th>
                            <td>
                                <input type="text" class="regular-text" name="ausgezeichnet_bewertungs_url" value="<?php echo esc_attr(get_option('ausgezeichnet_bewertungs_url')); ?>"/>
                                <!-- <p class="description"><?php echo __('Bewertungs-Url-Beschreibung', 'ausgezeichnet-org'); ?></p> -->
                            </td>
                        </tr>

                    </table>
                </div>
            </div>


            <div class="postbox">
                <div class="inside">
                    <h2><?php echo __('Siegel-Konfiguration-Headline', 'ausgezeichnet-org'); ?></h2>
                    <p><?php echo __('Siegel-Konfiguration-Beschreibung', 'ausgezeichnet-org'); ?></p>
                    <table class="form-table">            

                        <tr valign="top">
                            <th scope="row"><?php echo __('Bewertungssiegel anzeigen', 'ausgezeichnet-org'); ?></th>
                            <td><input type="checkbox" name="ausgezeichnet_siegel_aktiv" value="aktiv" <?php if(esc_attr(get_option('ausgezeichnet_siegel_aktiv'))=='aktiv'){ ?> checked<?php } ?>> <?php echo __('aktivieren', 'ausgezeichnet-org'); ?></td>
                        </tr>

                        <tr valign="top">
                            <th scope="row"><?php echo __('Siegel-Typ', 'ausgezeichnet-org'); ?></th>
                            <td>
                                <select name="ausgezeichnet_siegel_typ">
                                    <option value="square"><?php echo __('Quadrat', 'ausgezeichnet-org'); ?></option>
                                    <option value="rounded" <?php if(get_option('ausgezeichnet_siegel_typ') == 'rounded'){ ?>selected<?php } ?>><?php echo __('Gerundet', 'ausgezeichnet-org'); ?></option>
                                </select>
                            </td>
                        </tr>

                    </table>
                </div>
            </div>

            <?php 
            
            if (class_exists('Woocommerce')) { ?>

                <div class="postbox">
                    <div class="inside">
                        <h2><?php echo __('WooCommerce-Konfiguration-Headline', 'ausgezeichnet-org'); ?></h2>
                        <p><?php echo __('WooCommerce-Konfiguration-Beschreibung', 'ausgezeichnet-org'); ?></p>
                        <table class="form-table">            

                            <tr valign="top">
                                <th scope="row"><?php echo __('Review Collector anzeigen', 'ausgezeichnet-org'); ?></th>
                                <td><input type="checkbox" name="ausgezeichnet_review_collector_aktiv" value="aktiv" <?php if(get_option('ausgezeichnet_review_collector_aktiv')=='aktiv'){ ?> checked<?php } ?>> <?php echo __('aktivieren', 'ausgezeichnet-org'); ?></td>
                            </tr>

                            <tr valign="top">
                                <th scope="row"><?php echo __('Review-Link anzeigen', 'ausgezeichnet-org'); ?></th>
                                <td>
                                    <input type="checkbox" name="ausgezeichnet_email_link1" value="aktiv" <?php if(get_option('ausgezeichnet_email_link1')=='aktiv'){ ?> checked<?php } ?>> <?php echo __('In Bestellbestätigungs-Email', 'ausgezeichnet-org'); ?><br>
                                    <input type="checkbox" name="ausgezeichnet_email_link2" value="aktiv" <?php if(get_option('ausgezeichnet_email_link2')=='aktiv'){ ?> checked<?php } ?>> <?php echo __('In Bestellbearbeitungs-Email', 'ausgezeichnet-org'); ?><br>
                                    <input type="checkbox" name="ausgezeichnet_email_link3" value="aktiv" <?php if(get_option('ausgezeichnet_email_link3')=='aktiv'){ ?> checked<?php } ?>> <?php echo __('In Versandbestätigungs-Email', 'ausgezeichnet-org'); ?><br>
                                    <input type="checkbox" name="ausgezeichnet_email_link4" value="aktiv" <?php if(get_option('ausgezeichnet_email_link4')=='aktiv'){ ?> checked<?php } ?>> <?php echo __('In Rechnungs-Email', 'ausgezeichnet-org'); ?>
                                </td>
                            </tr>

                        </table>
                    </div>
                </div>

            <?php 
            
            }
            
            wp_nonce_field('ausgezeichnet_form_submit', 'ausgezeichnet_none');

            submit_button(); ?>
        </form>
    </div>
<?php

}
