<?php

/**
 * Siegel
 */


// Load Siegel JS
function ausgezeichnetLoadSiegel() {

    $ausgezeichnet_siegel_aktiv = get_option('ausgezeichnet_siegel_aktiv');

    if($ausgezeichnet_siegel_aktiv == 'aktiv'){
        $ausgezeichnet_organisations_id = get_option('ausgezeichnet_organisations_id');
        $ausgezeichnet_localize_string = ausgezeichnetLocalizeString();
        wp_enqueue_script('ausgezeichnet-org-siegel', 'https://siegel.ausgezeichnet.org/widgets/'.$ausgezeichnet_organisations_id.'/dynamic-seal.js?lang='.$ausgezeichnet_localize_string,'','',true);
    }

}
add_action( 'wp_enqueue_scripts', 'ausgezeichnetLoadSiegel');


// Inject Siegel
function ausgezeichnetInsertSiegel() {

    $ausgezeichnet_siegel_aktiv = get_option('ausgezeichnet_siegel_aktiv');

    if($ausgezeichnet_siegel_aktiv == 'aktiv'){
        $ausgezeichnet_siegel_typ = get_option('ausgezeichnet_siegel_typ');

        if($ausgezeichnet_siegel_typ != 'rounded'){
            $ausgezeichnet_siegel_typ = 'square';
        }
        echo '<div class="auorgDynamicSeal" auorg-data-type="'.$ausgezeichnet_siegel_typ.'"></div>';
    }
}
add_action( 'wp_body_open', 'ausgezeichnetInsertSiegel');




?>