<?php

/**
 * Admin Page
 */

// Create WordPress admin menu
function reachReviewSettings(){

    // reachReviewLocalize();

    // Plugin icon https://daext.com/blog/create-custom-svg-admin-icons-in-wordpress/
    $icon_base64 = 'PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCA2NDAgNTEyIj4NCjxwYXRoIHN0eWxlPSJmaWxsOiBibGFjayIgZD0iTTM1My44IDU0LjFMMzMwLjIgNi4zYy0zLjktOC4zLTE2LjEtOC42LTIwLjQgMEwyODYuMiA1NC4xbC01Mi4zIDcuNWMtOS4zIDEuNC0xMy4zIDEyLjktNi40IDE5LjhsMzggMzctOSA1Mi4xYy0xLjQgOS4zIDguMiAxNi41IDE2LjggMTIuMmw0Ni45LTI0LjggNDYuNiAyNC40YzguNiA0LjMgMTguMy0yLjkgMTYuOC0xMi4ybC05LTUyLjEgMzgtMzYuNmM2LjgtNi44IDIuOS0xOC4zLTYuNC0xOS44bC01Mi4zLTcuNXpNMjU2IDI1NmMtMTcuNyAwLTMyIDE0LjMtMzIgMzJsMCAxOTJjMCAxNy43IDE0LjMgMzIgMzIgMzJsMTI4IDBjMTcuNyAwIDMyLTE0LjMgMzItMzJsMC0xOTJjMC0xNy43LTE0LjMtMzItMzItMzJsLTEyOCAwek0zMiAzMjBjLTE3LjcgMC0zMiAxNC4zLTMyIDMyTDAgNDgwYzAgMTcuNyAxNC4zIDMyIDMyIDMybDEyOCAwYzE3LjcgMCAzMi0xNC4zIDMyLTMybDAtMTI4YzAtMTcuNy0xNC4zLTMyLTMyLTMyTDMyIDMyMHptNDE2IDk2bDAgNjRjMCAxNy43IDE0LjMgMzIgMzIgMzJsMTI4IDBjMTcuNyAwIDMyLTE0LjMgMzItMzJsMC02NGMwLTE3LjctMTQuMy0zMi0zMi0zMmwtMTI4IDBjLTE3LjcgMC0zMiAxNC4zLTMyIDMyeiIvPg0KPC9zdmc+';
    $icon_data_uri = 'data:image/svg+xml;base64,' . $icon_base64;

    add_menu_page(
        __('Reach & Review', 'reach-review'),
        __('Reach & Review', 'reach-review'),
        'manage_options',
        'reach-review',
        '',
        $icon_data_uri,
        58
    );

    add_submenu_page(
        'reach-review',    // parent_slug
        __('Allgemein', 'reach-review'), // page_title
        __('Allgemein', 'reach-review'),        // menu_title
        'manage_options',       // capability
        'reach-review',    // menu_slug
        'reachReviewPage'     // callback
    );

}
add_action('admin_menu','reachReviewSettings');


// general plugin page
function reachReviewPage(){
    // reachReviewLocalize();
    ?>

    <div class="wrap">
        <h1 class="wp-heading-inline"><?php echo __('Settings-Headline', 'reach-review'); ?></h1>
        <br><br>
        <div class="card">
            <div class="inside">
                <h2><?php echo __('Reach-Review-Headline', 'reach-review'); ?></h2> 
                <p><?php echo __('Reach-Review-Description', 'reach-review'); ?></p>

                <?php if(is_dir(plugin_dir_path( __DIR__ ).'/extensions/ausgezeichnet')){ ?>
                    <p><?php echo __('Review: ', 'reach-review'); ?><a href="<?php echo admin_url('admin.php');?>?page=reach-review-ausgezeichnet"><?php echo __('AUSGEZEICHNET.org', 'reach-review'); ?></a></p>
                <?php } ?>
                
                <?php if(is_dir(plugin_dir_path( __DIR__ ).'/extensions/ocoso') && SHOW_OCOSO_EXTENSION == TRUE){ ?>
                    <p><?php echo __('Reach: ', 'reach-review'); ?><a href="<?php echo admin_url('admin.php');?>?page=reach-review-ocoso"><?php echo __('OCOSO.io', 'reach-review'); ?></a></p>
                <?php } ?>
            </div>
        </div>
    </div>
                
<?php }


