<?php

// Create WordPress admin menu
function ausgezeichnetSettings(){

    add_submenu_page(
        'reach-review',    // parent_slug
        __('AUSGEZEICHNET.org', 'reach-review'), // page_title
        __('AUSGEZEICHNET.org', 'reach-review'),        // menu_title
        'manage_options',       // capability
        'reach-review-ausgezeichnet',    // menu_slug
        'reachReviewAusgezeichnetPage'     // callback
    );

    if(class_exists('Woocommerce')) {
        add_submenu_page(
            'reach-review',                // parent_slug
            __('WooCommerce Einstellungen', 'reach-review'), // page_title
            __('↳ WooCommerce', 'reach-review'),        // menu_title
            'manage_options',                   // capability
            'reach-review-woocommerce',        // menu_slug
            'reachReviewWoocommercePage'      // callback
        );
    }

}
add_action('admin_menu','ausgezeichnetSettings');


// Register database fields
function reachReviewFields() {        
    register_setting('reach-review-settings', 'reach_review_kontonummer');
    register_setting('reach-review-settings', 'reach_review_bewertungs_id');
    register_setting('reach-review-settings', 'reach_review_organisations_id');
    register_setting('reach-review-settings', 'reach_review_bewertungs_url');
    register_setting('reach-review-settings', 'reach_review_siegel_aktiv');
    register_setting('reach-review-settings', 'reach_review_siegel_typ');
    register_setting('reach-review-settings', 'reach_review_siegel_position');
    register_setting('reach-review-settings', 'reach_review_review_slider_aktiv');
    
    if(class_exists('Woocommerce')) {
        register_setting('reach-review-woocommerce', 'reach_review_review_collector_aktiv');
        register_setting('reach-review-woocommerce', 'reach_review_email_link1');
        register_setting('reach-review-woocommerce', 'reach_review_email_link2');
        register_setting('reach-review-woocommerce', 'reach_review_email_link3');
        register_setting('reach-review-woocommerce', 'reach_review_email_link4');
    }
}
add_action('admin_init', 'reachReviewFields');



// AUSGEZEICHNET page
function reachReviewAusgezeichnetPage(){ 

    settings_errors();
    ?>

    <div class="wrap">
        <h1 class="wp-heading-inline"><?php echo __('Settings-Ausgezeichnet', 'reach-review'); ?></h1>
        <p><?php echo __('Settings-Description', 'reach-review'); ?></p>
        <ol>
            <li><?php echo __('Settings-Description Listenpunkt 1', 'reach-review'); ?></li>
            <li><?php echo __('Settings-Description Listenpunkt 2', 'reach-review'); ?></li>
            <li><?php echo __('Settings-Description Listenpunkt 3', 'reach-review'); ?></li>
        </ol>

        <form method="post" action="options.php">
        <!-- <form method="post" action=""> -->
            <?php settings_fields('reach-review-settings'); ?>
            <?php do_settings_sections('reach-review-settings'); ?>

            <div class="postbox">
                <div class="inside">
                    <h2><?php echo __('Kunden-Konto-Headline', 'reach-review'); ?></h2> 
                    <p><?php echo __('Kunden-Konto-Beschreibung', 'reach-review'); ?></p>
                    
                    <table class="form-table">            

                        <tr valign="top">
                            <th scope="row"><?php echo __('Kontonummer', 'reach-review'); ?><span>*</span></th>
                            <td>
                                <input type="text" class="regular-text" name="reach_review_kontonummer" value="<?php echo esc_attr(get_option('reach_review_kontonummer')); ?>"/>
                            </td>
                        </tr>

                        <tr valign="top">
                            <th scope="row"><?php echo __('Individuelle Bewertungs-ID', 'reach-review'); ?><span>*</span></th>
                            <td>
                                <input type="text" class="regular-text" name="reach_review_bewertungs_id" value="<?php echo esc_attr(get_option('reach_review_bewertungs_id')); ?>"/>
                            </td>
                        </tr>

                        <tr valign="top">
                            <th scope="row"><?php echo __('Organisations-ID', 'reach-review'); ?><span>*</span></th>
                            <td>
                                <input type="text" class="regular-text" name="reach_review_organisations_id" value="<?php echo esc_attr(get_option('reach_review_organisations_id')); ?>"/>
                            </td>
                        </tr>

                        <tr valign="top">
                            <th scope="row"><?php echo __('Bewertungs-URL', 'reach-review'); ?><span>*</span></th>
                            <td>
                                <input type="text" class="regular-text" name="reach_review_bewertungs_url" value="<?php echo esc_attr(get_option('reach_review_bewertungs_url')); ?>"/>
                            </td>
                        </tr>

                    </table>
                </div>
            </div>

            <div class="postbox">
                <div class="inside">
                    <h2><?php echo __('Siegel-Konfiguration-Headline', 'reach-review'); ?></h2>
                    <p><?php echo __('Siegel-Konfiguration-Beschreibung', 'reach-review'); ?></p>
                    <table class="form-table">            

                        <tr valign="top">
                            <th scope="row"><?php echo __('Bewertungssiegel anzeigen', 'reach-review'); ?></th>
                            <td><input type="checkbox" name="reach_review_siegel_aktiv" value="aktiv" <?php if(esc_attr(get_option('reach_review_siegel_aktiv'))=='aktiv'){ ?> checked<?php } ?>> <?php echo __('aktivieren', 'reach-review'); ?></td>
                        </tr>

                        <tr valign="top">
                            <th scope="row"><?php echo __('Siegel-Typ', 'reach-review'); ?></th>
                            <td>
                                <select name="reach_review_siegel_typ">
                                    <option value="square"><?php echo __('Quadrat', 'reach-review'); ?></option>
                                    <option value="rounded" <?php if(get_option('reach_review_siegel_typ') == 'rounded'){ ?>selected<?php } ?>><?php echo __('Gerundet', 'reach-review'); ?></option>
                                </select>
                            </td>
                        </tr>

                        <tr valign="top">
                            <th scope="row"><?php echo __('Siegel-Position', 'reach-review'); ?></th>
                            <td>
                                <select name="reach_review_siegel_position">
                                    <option value="right" <?php if(get_option('reach_review_siegel_position') != 'left'){ ?>selected<?php } ?>><?php echo __('Rechts', 'reach-review'); ?></option>
                                    <option value="left" <?php if(get_option('reach_review_siegel_position') == 'left'){ ?>selected<?php } ?>><?php echo __('Links', 'reach-review'); ?></option>
                                </select> <?php echo __('(Nur Pro)', 'reach-review'); ?>
                            </td>
                        </tr>

                    </table>
                </div>
            </div>

            <div class="postbox">
                <div class="inside">
                    <h2><?php echo __('Review-Slider-Headline', 'reach-review'); ?></h2>
                    <p><?php echo __('Review-Slider-Beschreibung', 'reach-review'); ?></p>
                    <table class="form-table">            

                        <tr valign="top">
                            <th scope="row"><?php echo __('Review-Slider-Shortcode', 'reach-review'); ?></th>
                            <td><input type="checkbox" name="reach_review_review_slider_aktiv" value="aktiv" <?php if(esc_attr(get_option('reach_review_review_slider_aktiv'))=='aktiv'){ ?> checked<?php } ?>> <?php echo __('aktivieren', 'reach-review'); ?></td>
                        </tr>

                    </table>
                </div>
            </div>

            <?php 
            
            submit_button(); ?>
        </form>
    </div>
<?php

}