<?php

/**
 * Siegel
 */

// Load Siegel JS
function reachReviewLoadSiegel() {

    $reach_review_siegel_aktiv = get_option('reach_review_siegel_aktiv');

    if($reach_review_siegel_aktiv == 'aktiv'){
        $reach_review_organisations_id = get_option('reach_review_organisations_id');
        $reach_review_localize_string = reachReviewLocalizeString();
        wp_enqueue_script('reach-review-siegel', 'https://siegel.ausgezeichnet.org/widgets/'.$reach_review_organisations_id.'/dynamic-seal.js?lang='.$reach_review_localize_string,'','',true);
    }

}
add_action( 'wp_enqueue_scripts', 'reachReviewLoadSiegel');


// Inject Siegel
function reachReviewInsertSiegel() {

    $reach_review_siegel_aktiv = get_option('reach_review_siegel_aktiv');

    if($reach_review_siegel_aktiv == 'aktiv'){
        $reach_review_siegel_typ = get_option('reach_review_siegel_typ');
        $reach_review_siegel_position = get_option('reach_review_siegel_position');

        if($reach_review_siegel_typ != 'rounded'){
            $reach_review_siegel_typ = 'square';
        }
        echo '<div class="auorgDynamicSeal" auorg-data-type="'.$reach_review_siegel_typ.'" auorg-data-position="'.$reach_review_siegel_position.'"></div>';
    }
}
add_action( 'wp_body_open', 'reachReviewInsertSiegel');




?>