<?php

/**
 * Register settings for OCOSO
 * @return void
 */
function registerOcosoFields()
{
    register_setting('ocoso-settings', 'ocoso_enabled');
    register_setting('ocoso-settings', 'ocoso_id');
}

add_action('admin_init', 'registerOcosoFields');

function ocosoAdminComponent()
{
    settings_errors();
    ?>

    <div class="wrap">
        <h1 class="wp-heading-inline"><?php echo __('OCOSO-Admin-Headline', 'ocoso'); ?></h1>
        <p></p>
        <form method="post" action="options.php">
            <?php settings_fields('ocoso-settings'); ?>
            <?php do_settings_sections('ocoso-settings'); ?>
                  
                <div class="postbox">
                    <div class="inside">
                        <p><?php echo __('OCOSO-Admin-Description', 'ocoso'); ?></p>
                        <table class="form-table">

                            <tr valign="top">
                                <th scope="row"><?php echo __('OCOSO-Admin-Enabled', 'ocoso'); ?></th>
                                <td><input type="checkbox" name="ocoso_enabled" value="true" <?php if(esc_attr(get_option('ocoso_enabled'))=='true'){ ?> checked<?php } ?>> <?php echo __('activate', 'ocoso'); ?></td>
                            </tr>

                            <tr valign="top">
                                <th scope="row"><?php echo __('OCOSO-Admin-Id', 'ocoso'); ?></th>
                                <td><input type="text" class="regular-text" name="ocoso_id"
                                        value="<?php echo esc_attr(get_option('ocoso_id')); ?>"/></td>
                            </tr>

                        </table>
                    </div>
                </div>
            
            <?php submit_button(); ?>
        </form>
    </div>
    <?php
}

/**
 * Add submenu for OCOSO
 * @return void
 */
function ocosoSubmenu(){

    add_submenu_page(
        'reach-review',
        __('OCOSO Settings', 'ocoso'),
        __('OCOSO.io', 'ocoso'),
        'manage_options', 
        'reach-review-ocoso',
        'ocosoAdminComponent'
    );

}
add_action('admin_menu','ocosoSubmenu');