<?php

function loadOcosoScript()
{
    $is_ocoso_enabled = trim(get_option('ocoso_enabled')) == 'true';
    if($is_ocoso_enabled) {
        $ocoso_id = trim(get_option('ocoso_id'));

        if ($ocoso_id != '') {
            $reach_review_localize_string = reachReviewLocalizeString();
            wp_enqueue_script('ocoso-script', 'https://service.ocoso.io/ausgezeichnet/' . $ocoso_id . '/dynamic.js?lang=' . $reach_review_localize_string, '', '', true);
        }
    }
}

add_action('wp_enqueue_scripts', 'loadOcosoScript');

function ocosoInsertContentContainer($content)
{
    $is_ocoso_enabled = trim(get_option('ocoso_enabled')) == 'true';
    if ($is_ocoso_enabled) {
        $ocoso_id = trim(get_option('ocoso_id'));
        if ($ocoso_id != '') {
            if (is_singular() && in_the_loop() && is_main_query()) {
                $title = md5(get_the_title());
                $contentHash = md5($content);
                return $content
                    . '<div class="ocosoDynamicSeal" data-ocoso-id="' . $ocoso_id . '" data-ocoso-title="' . $title . '" data-ocoso-content="'.$contentHash.'">OCOSO-Container '.$ocoso_id.' '.$title.' '.$contentHash.'</div>';
            }
        }
    }
    return $content;
}

add_filter('the_content', 'ocosoInsertContentContainer');