<?php
//
// Copyright: 2024 Gebert & Partner Consultants
// Licence: MIT https://opensource.org/license/mit
//

/**
 * Find all installed extensions of the plugin reach-review.
 *
 * @param $extensionsDirectory string The directory that contains the extensions. Default is REACH_REVIEW_EXTENSIONS_DIR
 * @return array Path to extension entry file as string
 */
function reach_review_find_extensions($extensionsDirectory = REACH_REVIEW_EXTENSIONS_DIR)
{
    $foundExtensions = array();
    $candidates = scandir($extensionsDirectory);

    if($candidates) {
        foreach (array_diff($candidates, array('.', '..')) as $candidate) {
            $candidate_directory = $extensionsDirectory . DIRECTORY_SEPARATOR . $candidate;
            if (is_dir($candidate_directory) && is_readable($candidate_directory)) {
                $entry_file = $candidate_directory . DIRECTORY_SEPARATOR . $candidate . '.php';
                if (is_file($entry_file) && is_readable($entry_file)) {
                    $foundExtensions[] = str_replace(DIRECTORY_SEPARATOR, '/', $entry_file);
                }
            }
        }
    }

    return $foundExtensions;
}

/**
 * Loads all extensions found by reach_review_find_extensions() function.
 *
 * @return void
 */
function reach_review_load_extensions()
{
    foreach (reach_review_find_extensions() as $extension) {
        include_once $extension;
    }
}
