<?php

/**
 * Plugin Name:       Reach & Review
 * Plugin URI:        https://www.ausgezeichnet.org
 * Description:       Plugin zur Integration des eigenen AUSGEZEICHNET.org-Accounts in die Website.
 * Version:           1.2.3
 * Author:            ScreenDock GbR
 * Author URI:        https://screendock.de
 * Developer:         ScreenDock
 * Developer URI:     https://screendock.de
 * Text Domain:       reach-review
 * Domain Path: /languages
 *
 * License: GNU General Public License v3.0
 * License URI: http://www.gnu.org/licenses/gpl-3.0.html
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

// Localize plugin
function reachReviewLocalize() {
    load_plugin_textdomain( 'reach-review', false, dirname( plugin_basename( __FILE__ ) ) . '/languages/' );  
}
add_action('init', 'reachReviewLocalize');

require_once plugin_dir_path( __FILE__ ) . 'admin/admin-page.php';

// Load extensions
define('REACH_REVIEW_PLUGIN_DIR', dirname(__FILE__));
define('REACH_REVIEW_EXTENSIONS_DIR', plugin_dir_path(__FILE__) . 'extensions');
require_once plugin_dir_path( __FILE__ ) . 'includes/extensions.php';
reach_review_load_extensions();

// Show ocoso (optional)
define('SHOW_OCOSO_EXTENSION', FALSE);

// Hide ocoso
if(SHOW_OCOSO_EXTENSION != TRUE){
    function remove_ocoso_submenu() {
        remove_submenu_page(
            'reach-review', 
            'reach-review-ocoso'
        );
    }
    add_action('admin_menu', 'remove_ocoso_submenu', 11);
}